M=4;
DER = 1e-4;

%https://www.ieee802.org/3/bs/public/adhoc/smf/15_12_01/king_01_1215_smf.pdf
% pg 4!!!
Rel_Prob_Errors_per_Symbol = 2*(M-1)/M;
Qt_PAM2 = qfuncinv(DER);
Qt_PAM  = qfuncinv(DER/Rel_Prob_Errors_per_Symbol);

%% Set Qt_Correct =1 if you want to see impact
% to SER without correction
Qt_Correct = Qt_PAM2/Qt_PAM;
fprintf ('Relative probability of errors per symbol %.3f, Qt_Correction: %.4f\n', Rel_Prob_Errors_per_Symbol, Qt_Correct);


%% PAM symbol levels and thresholds
PAM_LUT = @(M) ((0:M-1)-(M-1)/2)/((M-1)/2);
LUT = PAM_LUT(M);
thresholds = diff(LUT)/2+LUT(1:end-1);

 A_s =1/(M-1);

 nsigma = sqrt(2)*erfcinv(2*DER);
 pdf = normal_dist(1,nsigma,A_s/1000);

 Nreps = 100;
 err_count = 0;
 Sym_count = 0;
 
 for jj = 1:Nreps
 Syms = randi([0,M-1],1,1e6);
 Signal = LUT(Syms+1);
 
 Noise = randn(size(Signal));
    [hist,bins]= histcounts(Noise,pdf.x);
    idx = find(cumsum (hist/sum(hist))<=DER,1,'last');
   	Sigma_Ser = 1/abs(pdf.x(idx))*A_s *Qt_Correct;
    
    % Classic COM A_NI setup for DER
    Noise= Noise/abs(pdf.x(idx))*A_s;
    
    % Fix for accurate PAM 4 SER    
   	Noise = Noise * Qt_Correct; 

Sig_w_Noise = Signal+Noise;
    Decisions = sum(Sig_w_Noise > thresholds',1);
    err = Decisions ~= Syms;
    
    err_count = err_count +  sum(err);
    Sym_count = Sym_count + length(err);
    
 end
 
err_rate = err_count/Sym_count;
fprintf('SER: %.1e\n',err_rate)
 
 function pdf = normal_dist(sigma,nsigma,binsize)
    % fix for pdf to get accurate CDF
    nsigma=2*nsigma; 
    
    pdf.BinSize=binsize;
    pdf.Min=-round(nsigma*sigma/binsize);
    pdf.x=(pdf.Min:-pdf.Min)*binsize;
    pdf.y=exp(-pdf.x.^2/(2*sigma^2+eps));
    pdf.y=pdf.y/sum(pdf.y);
 end
 
 function y = qfuncinv(x)
%QFUNCINV  Inverse Q function.
%   Y = QFUNCINV(X) returns the argument of the Q function at which the Q function's
%   value is X.  X must be a real array with elements between 0 and 1, inclusive.
%
%   For a scalar X, the Q function is 1 minus the cumulative distribution function of
%   the standardized normal random variable evaluated at X.  The Q function is
%   defined as:
%
%     Q(x) = 1/sqrt(2*pi) * integral from x to inf of exp(-t^2/2) dt
%
%   The Q function is related to the complementary error function (erfc) according to
%
%     Q(x) = 0.5 * erfc(x/sqrt(2))
%
%   See also QFUNC, ERF, ERFC, ERFCX, ERFINV, ERFCINV.

%   Copyright 1996-2016 The MathWorks, Inc.

if (~isreal(x) || ischar(x))
  error(message('comm:qfuncinv:InvalidArg')); 
end

% The erfcinv function performs error checking for all real arguments that are
% outside the range 0<X<1

y = sqrt(2) * erfcinv(2*x);
 end