
M=4;

dB = 1;
SNR = 18*dB;
%% PAM symbol levels and thresholds
PAM_LUT = @(M) ((0:M-1)-(M-1)/2)/((M-1)/2);
LUT = PAM_LUT(M);

 Syms = randi([0,M-1],1,1e6);
 Signal = LUT(Syms+1);
 
 Sig_var = var(Signal);
 N_var_taget = Sig_var/(10^(SNR/10));
 Noise = sqrt(N_var_taget)*randn(size(Signal));
 

 Signal_Noise = Signal +  Noise;
 MSE_Calc = @(Gain) mean((Signal-Gain*Signal_Noise).^2);
 Gain = fminsearch (MSE_Calc,1);
 
 dB_adjust = 20*log10(MSE_Calc(Gain)/MSE_Calc(1));
 
 fprintf ('Optimum Gain for MSE at %.1f dB SNR: %.3f, %.3f dB level adjustment\n',SNR, Gain,  dB_adjust)
